package Back;

import java.io.*;
import java.util.*;

public class Node<T extends Serializable & Comparable<T> >  implements Comparable<Node<T>>  {
    private T             value;
    private List<Node<T>> sons;
    private Node<T> parent;
    boolean _find, _add;


    /**
     * konstruktor nastavi hodnotu, potomkov a _find a _add
     * ktore sa vyuzivaju pri animacii
     * @param value hodnota vrcholu
     * @param sons list potomkov - ak null nastavi sa na
     *             prazdny ArrayList
     */
    public Node(T value, List<Node<T>> sons) {
        this.value = value;
        _find = _add = false;
        if ( sons == null) {
            this.sons = new ArrayList<Node<T>>();
        } else {
            this.sons = new ArrayList<Node<T>>(sons);
        }
    }

    /**
     * prazdny konstruktor, hodnota je null,
     * potomkovia prazdny ArrayList
     */
    public Node(){
        this.value = null;
        this.sons = new ArrayList<Node<T>>();
        _find = _add = false;
    }

    /**
     * konstruktor ktory sa vyuziva pri citani stromu
     * z JSON suboru
     * @param s scanner z ktoreho sa rekurzivne citaju udaje
     *
     */
    public Node( Scanner s){
        _find = _add = false;
        String riadok;

        s.nextLine(); //{ "Ostatne.Node" : {
        riadok = s.nextLine(); //"value" : "i",
        riadok = riadok.replace("\"value\" : ", "").trim();
        if ("null,".equals(riadok)) {
            value = null;
        } else {
            riadok = riadok.replace("\"", "");
            riadok = riadok.replace(",", "").trim();
            value = (T) (riadok);
        }

        sons = new ArrayList<Node<T>>();

        riadok = s.nextLine(); //"sons" :  null
        riadok = riadok.replace("\"sons\" : ", "").trim();

        if (!riadok.equals("null")) {
            while (!riadok.equals("}") & !riadok.equals("]")) {
                Node<T> x = new Node<T>( s );
                sons.add(x);
                riadok = s.nextLine();
                riadok = riadok.trim();
            }
            riadok = s.nextLine();
        }

        s.nextLine();
    }

    /**
     * @return vracia premennu _find s ktorou pracuje animacia
     */
    public boolean getFind() {
        return _find;
    }

    /**
     * nastavenie _find
     * @param find prideli sa do _find
     */
    public void setFind( boolean find) {
        this._find = find;
    }


    /**
     * @return vracia premennu _add s ktorou pracuje animacia
     */
    public boolean getAdd() {
        return _add;
    }

    /**
     * nastavenie _add
     * @param add prideli sa do _add
     */
    public void setAdd( boolean add) {
        this._add = add;
    }


    /**
     * urobi vlozi Ostatne.Node do synov na urcene miest
     * @param i pozicia kde sa ma Ostatne.Node vlozit
     * @param node Ostatne.Node ktory bude vkladany
     */
    public void insertNode( int i, Node<T> node ) {
        if ( i == -1 ) {
            this.sons.add(node);
        } else {
            this.sons.add(i, node);
        }
    }

    public void removeNode(  Node<T> node ) {
       sons.remove(node);
    }


    /**
     * @return vrati hodnoru vrcholu
     */
    public T getValue() {
        return value;
    }

    /**
     * nastavuje hodnotu vrcholu
     * @param value hodnota ktora sa priradi
     */
    public void setValue(T value) {
        this.value = value;
    }

    /**
     * @return vrati synov vrcholu
     */
    public List<Node<T>> getSons() {
        return sons;
    }


    /**
     * nastavuje synov vrcholu
     * @param sons list ktory sa priradi
     */
    public void setSons(List<Node<T>> sons) {
        if ( sons == null ){
            this.sons = new ArrayList<Node<T>>();
        } else {
            this.sons = sons;
        }
    }


    /**
     * @return vracia pocet vsetkych podvrcholov + seba
     */
    public int size() {
        int count = 1;
        if (sons != null) {
            for (Node<T> son : sons)
                if (son != null)
                    count += son.size();
        }
        return count;
    }


    /**
     * @return vrati vysku stromu
     */
    public int height(){
        int h = 1;

        if ( sons == null ) return h;
        if ( sons.size() == 0) return h;

        for ( Node son : sons) {
            int s_h = son.height();
            if (s_h > h) {
                h = s_h;
            }
        }

        return h+1;
    }

    /**
     * najde najvacsieho syna, vypocita priemernu odchylku ostatnych synov od neho
     * @return odchylka velkosti
     */
    public double balance(){
        if ( sons == null) return 0;
        if ( sons.size() == 0 | sons.size() == 1  ) return 0;

        ArrayList<Integer> list = new ArrayList<Integer>();

        for ( Node n : sons ){
            list.add(n.size()-1);
        }

        //return ( list.isEmpty() )? 0 : Collections.max(list) - Collections.min(list);

        int m = Collections.max(list);
        double vys = 0;

        for ( int size : list ){
            vys += m - size;
        }

        return ( vys == 0 ) ? 0d :  Math.round( vys*100 / (list.size()-1) ) / 100  ;


    }

    private void add( Node<T> node ){ // efektivnejsia verzia pri animacii, pouziva _add
        if ( node != null ) {
            int i = 0;
            for (Node<T> n_son : node.getSons()) {
                if ( this.sons.contains(n_son) ){
                    for ( Node w_son : getSons()) {

                        if (w_son.equals(n_son)) {
                            w_son.add(n_son);
                            break;
                        }
                    }
                } else {
                    this.sons.add(i,n_son);
                }
                i++;
            }
        }
    }
    /**
     * v podstrome rekurzivne vyhlada ci sa pozadovany vrchol nachadza niekde v podstrome
     * ak ano, tak zavola privatnu funkciu ktora rekurzivne prida
     * nove vrcholy
     * @param node vrchol ktory ideme pripajat
     * @return ak je node null alebo sa nenachadza v podstrome vrati false inac true
     */
    public boolean join( Node<T> node ){
        if ( node == null) return false;

        Node<T> where = findByNode(node);
        if ( where == null) return false;

        where.add(node);
        return true;
    }


    /**
     * z hodnoty vytvori vrchol ktoremu nasledne
     * v podstrome rekurzivne vyhladava otca,
     * ak existuje,konstruktor tento vrchol mu odstrani zo synov,
     * inac skontroluje ci sa nejedna o aktualny vrchol
     * vtom pripade si vynuluje hodnotu a synov
     * @param val hodnota vrcholu ktory ideme odstranit
     * @return ak otec neexistuje vrati false, inac true
     */
    public boolean remove( T val ){
        Node<T> father = findFatherByValue(val);

        if ( father == null ) {
            if ( findByValue(val).equals(this)){ // ROOT
                value = null;
                sons = new ArrayList<>();
                return true;
            }
        }

        for ( Node<T> son : father.sons ){
            if ( son.value.equals(val)){
                father.sons.remove(son);
                return true;
            }
        }

        return false;
    }


    /**
     * pomocou parametrov najde "smerniky" na vrcholy s ktorymi sa bude
     * pracovat, nasledne vrcholu _where prida do synov vrchol _which ktory odstrani
     * z povodneho miesta
     * @param _where hodnota vrcholu ktoremu sa bude pridavat syn
     * @param _which hodnota vrcholu ktory sa bude premiestnovat
     * @return ak sa v strome nenachadza vrchol s tymito hodnotami vracia false inac true
     */
    public boolean move( T _which, T _where ){

        Node<T> which = findByValue(_which);
        Node<T> where = findByValue(_where);

        if ( which == null | where == null ) return false;

        remove(_which);

        if ( where.sons.contains(which)){
            where.add(which);
        } else {
            where.sons.add(which);
        }
        return true;

    }

    /**
     * hlada v strome vrchol s danou hodnotou, ak hodnota nie je null, porovna ich
     * inac porovna ci je aj hladana hodnota null
     * @param elem hladana hodnota
     * @return true ak sa v strome nachadza vrchol s touto hodnotou inac false
     */
    public boolean contains(T elem) {
        if ( value != null ) {
            if (value.compareTo(elem) == 0 ) {
                return true;
            }
        } else {
            if ( elem == null ){
                return true;
            }
        }

        if (sons != null) {
            for (Node<T> son : sons)
                if (son != null)
                    if ( son.contains(elem) ) return true;
        }
        return false;

    }

    /**
     * urobi vrchol s touto hodnotou, zavola rovnaku funkciu s parametrom ktory je vrchol
     * @param val hladana hodnota
     * @return ak sa v strome nachadza vrchol s touto hodnotou tak ho vrati jeho otca inac vrati null
     */
    public Node<T> findFatherByValue( T val ){
        Node n = new Node(val,null);
        return findFatherByNode(n);

    }

    /**
     * rekurzivne prechadza strom, kontroluje ci sa dany vrchol nachadza
     * u niekoho v synoch, ak ano tak ho vrati
     * @param n hladany vrchol
     * @return otec hladaneho vrcholu ak sa nachadza inac vrati null
     */
    public Node<T> findFatherByNode( Node<T> n ){
        if ( n == null ) return null;
        if ( this.equals(n) ) return null;

        if ( sons == null ) return null;
        if ( this.sons.contains(n) ) return this;

        if ( sons != null ){
            for ( Node<T> son : sons){
                Node<T> s = son.findFatherByNode(n);
                if ( s != null ) return s;
            }
        }

        return null;
    }


    /**
     * urobi vrchol s touto hodnotou, zavola rovnaku funkciu s parametrom ktory je vrchol
     * @param val hladana hodnota
     * @return vrchol s pozadovanou hodnotou ak sa nachadza inac null
     */
    public Node<T> findByValue(T val){
        Node<T> node = new Node<T>(val, null);
        return findByNode(node);
    }

    /**
     * zavola funkciu findFather
     * ak vrati null - vrchol sa v strome nenachadza vracia null
     * ak vrati Ostatne.Node - vojde do jeho synov, najde pozadovany vrchol ktory vrati
     * @param  node hladany vrchol
     * @return vrchol s pozadovanou hodnotou ak sa nachadza inac null
     */

    public Node<T> findByNode( Node<T> node){
        if ( node == null ) return null;
        if ( this.equals(node) ) return this;

        Node<T> father = findFatherByNode(node);
        if ( father == null ) return null;

        for ( Node<T> son : father.getSons() ){
            if ( son.equals(node) ){
                return son;
            }
        }

        return null;
    }

    /**
     * @return vrati list listov, kde jeden list reprezentuje jednu uroven stromu
     */
    public List<ArrayList<Node<T>>> getByLevels(){
        ArrayList<ArrayList<Node<T>>> list = new ArrayList<ArrayList<Node<T>>>();

        ArrayList<Node<T>> s = new ArrayList<Node<T>>();
        s.add(this);

        while ( s.size() > 0){
            list.add(s);
            s = new ArrayList();

            ArrayList<Node<T>> x = list.get(list.size()-1);
            for ( Node<T> n : list.get(list.size()-1)){
                s.addAll(n.getSons());
            }
            s.remove(null);
        }

        return list;
    }

    /**
     * @return vrati hash vrcholu
     */
    @Override
    public int hashCode() {
        return value != null ? value.hashCode() : 0;
    }

    /**
     * vrati hodnost triedy a hodnoty
     * @o objekt s ktorym zistuje ci sa rovna s this
     * @return true ak o je rovnakej triedy a hodnoty sa rovnaju, inak false
     */
    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        Node<?> node = (Node<?>) o;

        return Objects.equals(value, node.value);
    }

    /**
     * zavola private metodu compare ktora ma 2 Ostatne.Node parametre do ktorych
     * vlozi this a parameter node
     * priv metoda porovnava hodnoty v preorder poradi
     * null je mensi ako hodnota
     * @param node vrchol s ktorym porovnava
     * @return vrati kladne cislo ak je this vacsi, zaporne ak node, 0 ak sa rovnaju
     */
    @Override
    public int compareTo(Node<T> node) {
        return compare(this, node);
    }

    private int compare(Node<T> n1, Node<T> n2 ){

        if ( n1 == null & n2 == null){ return 0; }
        if ( n1 == null) return -1;
        if ( n2 == null) return 1;

        if ( n2.value == null & n1.value == null) return 0;
        if ( n1.value != null & n2.value == null) return 1;
        if ( n2.value != null & n1.value == null) return -1;

        if ( n1.value.compareTo(n2.value) != 0){
            return n1.value.compareTo(n2.value);
        }

        if ( n1.sons == null & n2.sons == null) return 0;
        if ( n1.sons != null & n2.sons == null) return 1;
        if ( n2.sons != null & n1.sons == null)return -1;

        int kolko = Math.min(n1.sons.size(), n2.sons.size());

        for (int i = 0; i < kolko; i++) {
            Node<T> son1 = n1.sons.get(i);
            Node<T> son2 = n2.sons.get(i);

            if ( son1 == null & son2 == null){
                continue;
            }

            if ( son1 == null){ return -1; }
            if ( son2 == null){ return 1;}

            if ( compare(son1, son2) != 0) {
                return compare(son1, son2);
            }

        }

        if ( n1.sons.size() == n2.sons.size() ){
            return 0;
        }

        return ( n1.sons.size() > n2.sons.size())? 1 : -1;
    }


    /**
     * @return vrati hodnotu premenenu na string
     *
     * po odkomentovani vypisuje rekurzivne aj podstrom vo formate
     *  this( son1( son11( .. ), .. ), son2( .. ), .. ))
     */
    @Override
    public String toString() {
        return value.toString();
            /*
            StringBuilder vys =  new StringBuilder();
            vys.append( (value == null )?"null": value.toString() );
            if (sons.size() != 0) {
                vys.append("(");
                for (Ostatne.Node<T> son : sons) {
                    if (sons.size() != 0) {
                        vys.append(son.toString());
                    } else {
                        vys.append("null");
                    }
                    vys.append(",");
                }
                vys.deleteCharAt(vys.length()-1);
                vys.append(")");
            }

            return vys.toString();
             */

    }

    /**
     * @return vratis strom v tvare:
     * this --> son1 --> son11
     *               --> son12
     *      --> son2
     */
    public String print(){
        return print(0);
    }

    private String print( int odsadenie){
        StringBuffer s = new StringBuffer();

        s.append(value);
        //s.append("Add" + this._add );

        int ods = s.length() + odsadenie;
        boolean o = false;
        if ( sons.size() != 0 ) {
            for (Node n : sons) {
                if (n == null) {
                    s.append("null");
                    continue;
                }
                if (o) {
                    s.append(" ".repeat(ods));
                }

                if (o == false) {
                    o = true;
                }

                s.append(" --> ");
                s.append(n.print(ods + 5));
                s.append("\n");

            }
        }


        return s.toString().replaceAll("\n{2,}","\n" );
    }

    /**
     * @param odsadenie aby to pekne vyzeralo, pouziva sa odsadenie
     * @return vrati String stromu ktory je prisposobeny na ukladanie
     * do JSONu
     */
    public String getJSon(int odsadenie ){
        StringBuffer s = new StringBuffer();
        s.append(" ".repeat(odsadenie)   +"{ \"Ostatne.Node\" : { \n");
        s.append(" ".repeat(odsadenie+2) + "\"value\" : ");

        if ( value instanceof Integer || value instanceof Double ){
            s.append( value );
            s.append(",\n");
        } else {
            s.append("\"" + value.toString() + "\",\n");
        }

        s.append(" ".repeat(odsadenie+2) + "\"sons\" : ");

        if ( sons == null ) {
            s.append(" null ");
        } else if ( sons.size() == 0 ){
            s.append(" null ");
        } else {
            s.append(" [ \n");
            for (Node<T> son : sons) {
                s.append(son.getJSon(odsadenie+4));
                s.append(",\n");
            }
            s.delete(s.length()-2, s.length()-1);
            s.append(  " ".repeat(odsadenie+4) + "]");
        }

        s.append("\n"+ " ".repeat(odsadenie+2) +"}\n");
        s.append(" ".repeat(odsadenie) +"}");
        return s.toString();
    }


    public static void main(String[] args) {
        Node<String> n_dabkc = new Node<>("d",
                List.of(
                        new Node<>("a", null),
                        new Node<>("b", null),
                        new Node<>("k", null),
                        new Node<>("c", null))
        );

        Node<String> n_habcdefg = new Node<>("h",
                List.of(
                        new Node<>("d",
                                List.of(
                                        new Node<>("a", null),
                                        new Node<>("b", null),

                                        new Node<>("c", null))
                        ),
                        new Node<>("e",
                                List.of(
                                        new Node<>("f", null),
                                        new Node<>("g", null),
                                        ///new Ostatne.Node<>(null,null),
                                        new Node<>("i", null))
                        )));


        System.out.println(n_habcdefg.print());


        Node<Double> n_12345 = new Node<>(1d,
                List.of(
                        new Node<>(2d, null),
                        new Node<>(3d, null),
                        new Node<>(4d, null),
                        new Node<>(5d, null))
        );

        System.out.println(n_12345.print());


        System.out.println(n_habcdefg.print());
        System.out.println(n_dabkc.print());

        n_habcdefg.join(n_dabkc);
        System.out.println(n_habcdefg.print());

        System.out.println( "compare :  " + n_habcdefg.compareTo(n_dabkc));
        System.out.println(n_dabkc.compareTo(n_habcdefg));
        System.out.println("h".compareTo("d"));


 /*
        System.out.println(n_habcdefg.findByValue("e"));
        System.out.println(n_habcdefg.findByNode( new Ostatne.Node("e",null)));
        System.out.println(n_habcdefg.findByValue("h"));
        System.out.println(n_habcdefg.findFatherByValue("h"));
        System.out.println(n_habcdefg.balance());



        n_habcdefg.join(n_dabkc);
        System.out.println(n_habcdefg.print());

        System.out.println(n_habcdefg.move("e", "h"));
        System.out.println(n_habcdefg.print());
        System.out.println(n_habcdefg.move("e", "h"));

        System.out.println(n_habcdefg.getByLevels());

        System.out.println(n_habcdefg.getJSon(0));
 */

    }
}


/*

    private Object fromString( String s ) throws IOException,
            ClassNotFoundException {
        byte [] data = Base64.getDecoder().decode( s );
        ObjectInputStream ois = new ObjectInputStream(
                new ByteArrayInputStream(  data ) );
        Object o  = ois.readObject();
        ois.close();
        return o;
    }


    private String toString( Serializable o ) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream( baos );
        oos.writeObject( o );
        oos.close();
        return Base64.getEncoder().encodeToString(baos.toByteArray());
    }
 */